class GuidedJetShell extends JetShell;

var int NumBullets, NumRockets, Fuel;
var bool bLeft;
var int Shield;
var bool bAlert, bAcolor;
var int Acolor,Bcolor,Ccolor;
var CTFFlag MyFlag;
var Pawn Guider;
var rotator OldGuiderRotation, GuidedRotation;
var float CurrentTimeStamp, LastUpdateTime,ClientBuffer,ServerUpdate;
var bool bUpdatePosition;
var bool bDestroyed;

var SavedMove SavedMoves;
var SavedMove FreeMoves;

var vector RealLocation, RealVelocity;

replication
{
	// Things the server should send to the client.
	unreliable if( Role==ROLE_Authority )
		ClientAdjustPosition, bDestroyed;
	unreliable if ( Role==ROLE_Authority && bNetOwner && bNetInitial )
		GuidedRotation, OldGuiderRotation;
	unreliable if( Role==ROLE_Authority && !bNetOwner )
		RealLocation, RealVelocity;
	unreliable if( Role==ROLE_AutonomousProxy )
		ServerMove;
}

function DrawFlagsOnCompas(canvas C, CTFFlag Flag)
{
local float Xpos, XL, YL, X, Y, F, Ypos, Dist;
local Pawn P;
local int Degrees;
local Vector XX, YY, ZZ, FX, FY, FZ, Dir;
local Rotator Rot;

	P = Pawn(Owner);
	Dir = Normal(Flag.Location) - Normal(P.Location);
	Rot = Rotator(Dir) - P.Rotation;
	if ( Flag.Team == 0 )
		{
		c.DrawColor.R = 255;
		c.DrawColor.G = 0;
		c.DrawColor.B = 0;
		F = float(Rot.Yaw - 16384) / 10430.37835;
		}
	else
		{
		c.DrawColor.R = 0;
		c.DrawColor.G = 0;
		c.DrawColor.B = 255;
		F = float(Rot.Yaw - 16384) / 10430.37835;
		}
	C.Style = ERenderStyle.STY_Masked;

	XPos = C.ClipX * 0.5 - 227;
	YPos = C.ClipY - 69;

	Dist = VSize(Flag.Location - P.Location);
	YL = Dist / 150;
	if ( YL > 48 )
		YL = 48;
	else if ( YL < 2 )
		YL = 2;
	if ( P.PlayerReplicationInfo.HasFlag != None && Flag.Team != P.PlayerReplicationInfo.Team )
		YL = 0;

	X = Cos(F);
	Y = Sin(F);
	C.SetPos(Xpos + YL * X  , Ypos + YL * Y );
	c.DrawIcon(Texture'icon_star', 0.25);

}

singular function TakeDamage( int NDamage, Pawn instigatedBy, Vector hitlocation, 
						vector momentum, name damageType )
{
	if ( NDamage > 5 )
		{
		Shield -= NDamage;
		if ( Shield < 1 )
			{
			Pawn(Owner).TakeDamage(1000, instigator, hitlocation, 1000 * Hitlocation, 'ShotDown');
			PlaySound(Sound'Expl03',,6.0);
			spawn(class'WarExplosion',,,Location);
			HurtRadius(Damage,250.0, MyDamageType, MomentumTransfer, HitLocation );
			RemoteRole = ROLE_SimulatedProxy;	 		 		
 			Destroy();
			}
		}
}

function DrawCockpit(canvas C)
{
local float FrameWidth;

	DrawRadar(C);

	C.DrawColor.R = 255;
	C.DrawColor.G = 255;
	C.DrawColor.B = 255;

	//Setup metal base:
	C.Style = ERenderStyle.STY_Masked;
	C.SetPos(C.ClipX * 0.5 - 400, c.ClipY - 180);
	C.DrawTile(Texture'UTMenu.Skins.FrameTop', 800, 64, 0, 0, 256, 32);
	C.SetPos(C.ClipX * 0.5 - 400, c.ClipY - 116);
	C.DrawTile(Texture'UTMenu.Skins.OrdersMid', 800, 128, 0, 0, 256, 32);

	// Setup Screen Element:
	C.SetPos(C.ClipX * 0.5 - 128, c.ClipY - 180);
	c.DrawIcon(Texture'Element_Screen', 1);

	// Draw Screws:
	C.SetPos(C.ClipX * 0.5 - 356, c.ClipY - 32);
	c.DrawIcon(Texture'ScrewHead', 0.5);
	C.SetPos(C.ClipX * 0.5 - 356, c.ClipY - 130);
	c.DrawIcon(Texture'ScrewHead', 0.5);
	C.SetPos(C.ClipX * 0.5 + 324, c.ClipY - 32);
	c.DrawIcon(Texture'ScrewHead', 0.5);
	C.SetPos(C.ClipX * 0.5 + 324, c.ClipY - 130);
	c.DrawIcon(Texture'ScrewHead', 0.5);

	//Draw cockpit frame:
	if ( C.ClipX > 800 )
		{
		FrameWidth = (C.ClipX - 800) * 0.5;
		C.SetPos(0, c.ClipY - 170);
		C.DrawTile(Texture'LeftFrame', FrameWidth, 170, 0, 0, 512, 512);
		C.SetPos(C.ClipX - FrameWidth, c.ClipY - 170);
		C.DrawTile(Texture'RightFrame', FrameWidth, 170, 0, 0, 512, 512);
		}

	// Setup Compass Element:
	C.SetPos(C.ClipX * 0.5 - 288, c.ClipY - 130);
	c.DrawIcon(Texture'Element_Compas', 0.5);

	// Setup Radar Element:
	C.Style = ERenderStyle.STY_Normal;
	C.SetPos(C.ClipX * 0.5 + 160, c.ClipY - 130);
	c.DrawIcon(Texture'Element_Radar', 0.5);
	
	DrawCompas(C);
	DrawScreenInfo(C);
	DrawFlags(C);
	DrawRadarDots(C);
}

simulated function DrawFlags( canvas Canvas )
{
local int X, Y, i;
local CTFFlag Flag;
local bool bAlt;
local TournamentGameReplicationInfo GRI;
local TeamInfo TI;

	GRI = TournamentGameReplicationInfo(PlayerPawn(Owner).GameReplicationInfo);
	
	X = Canvas.ClipX * 0.5 - 80;
	Y = Canvas.ClipY - 40;
			
	for ( i=0; i<2; i++ )
		{
		Flag = CTFReplicationInfo(PlayerPawn(Owner).GameReplicationInfo).FlagList[i];
		if ( Flag != None )
			{
			if ( Flag.Team == 0 )
				{
				Canvas.DrawColor.R = 255;
				Canvas.DrawColor.G = 0;
				Canvas.DrawColor.B = 0;
				}
			else
				{
				Canvas.DrawColor.R = 0;
				Canvas.DrawColor.G = 0;
				Canvas.DrawColor.B = 255;
				}

			TI = GRI.Teams[i];
			if ( i == 0 )
				DrawBigNum(Canvas, int(TI.Score), Canvas.ClipX * 0.5  - 54 , Canvas.ClipY - 40, 1);
			else
				DrawBigNum(Canvas, int(TI.Score), Canvas.ClipX * 0.5  - 12 , Canvas.ClipY - 40, 1);

			Canvas.SetPos(X,Y);

			if (Flag.Team == Pawn(Owner).PlayerReplicationInfo.Team)
				MyFlag = Flag;
			if ( Flag.bHome )
				{
				Canvas.DrawIcon(texture'I_Home', 1);
				}
			else if ( Flag.bHeld )
				{
				Canvas.DrawIcon(texture'I_Capt', 1);
				if ( MyFlag != Flag )
					{
					if ( PlayerPawn(Owner).PlayerReplicationInfo.HasFlag != None )
						{
						DrawYouGotTheFlag(Canvas);
						}
					else
						{
						DrawTeamGotTheFlag(Canvas);
						}
					}
				else
					{
					DrawEnemyGotTheFlag(Canvas);
					}
				}
			else
				{
				Canvas.DrawIcon(texture'I_Down', 1);
				if ( MyFlag != Flag )
					{
					if ( PlayerPawn(Owner).PlayerReplicationInfo.HasFlag != None )
						{
						DrawYouGotTheFlag(Canvas);
						}
					else
						{
						DrawTeamGotTheFlag(Canvas);
						}
					}
				else
					{
					DrawEnemyGotTheFlag(Canvas);
					}
				}
			}
		DrawFlagsOnCompas(Canvas, Flag);
		X = Canvas.ClipX * 0.5 + 58;
		}
}

function DrawYouGotTheFlag(canvas C)
{
local float DrawScale,Size;

	C.DrawColor.R = 0;
	C.DrawColor.G = Bcolor;
	C.DrawColor.B = 0;
	Bcolor -= 8;
	if (Bcolor < 0 )
		Bcolor = 255;

	DrawScale = (C.ClipX * 0.75) / 1024;
	Size = 1024 * DrawScale;
	C.Style = ERenderStyle.STY_Translucent;
	C.SetPos(C.ClipX * 0.5 - 0.5 * Size, 16);
	c.DrawIcon(Texture'YouGotTheFlag', DrawScale);
}

function DrawTeamGotTheFlag(canvas C)
{
local float DrawScale,Size;

	C.DrawColor.R = 0;
	C.DrawColor.G = Bcolor;
	C.DrawColor.B = 0;
	Bcolor -= 8;
	if (Bcolor < 0 )
		Bcolor = 255;

	DrawScale = (C.ClipX * 0.75) / 1024;
	Size = 1024 * DrawScale;
	C.Style = ERenderStyle.STY_Translucent;
	C.SetPos(C.ClipX * 0.5 - 0.5 * Size, 16);
	c.DrawIcon(Texture'TeamGotTheFlag', DrawScale);
}

function DrawEnemyGotTheFlag(canvas C)
{
local float DrawScale,Size;

	C.DrawColor.R = Ccolor;
	C.DrawColor.G = 0;
	C.DrawColor.B = 0;
	Ccolor -= 7;
	if (Ccolor < 0 )
		Ccolor = 255;

	DrawScale = (C.ClipX * 0.75) / 1024;
	Size = 1024 * DrawScale;
	C.Style = ERenderStyle.STY_Translucent;
	C.SetPos(C.ClipX * 0.5 - 0.5 * Size, 64);
	c.DrawIcon(Texture'EnemyGotTheFlag', DrawScale);
}

simulated function DrawDigit(Canvas Canvas, int d, int Step, float UpScale, out byte bMinus )
{
	if ( bMinus == 1 )
	{
		Canvas.CurX -= Step;
		Canvas.DrawTile(Texture'BotPack.HudElements1', UpScale*25, 64*UpScale, 0, 64, 25.0, 64.0);
		bMinus = 0;
	}
	if ( d == 1 )
		Canvas.CurX -= 0.625 * Step;
	else
		Canvas.CurX -= 0.25 * Step;		
	Canvas.DrawTile(Texture'BotPack.HudElements1', UpScale*25, 64*UpScale, d*25, 0, 25.0, 64.0);
	Canvas.CurX += 7*UpScale;
}

// DrawBigNum should already have Canvas set up
// X and Y should be the left most allowed position of the number (will be adjusted right if possible)
simulated function DrawBigNum(Canvas Canvas, int Value, int X, int Y, optional float ScaleFactor)
{
	local int d, Mag, Step;
	local float UpScale;
	local byte bMinus;

	UpScale = 1;

	Canvas.CurX = X;	
	Canvas.CurY = Y;
	Step = 16 * UpScale;
	if ( Value < 0 )
		bMinus = 1;
	Mag = FMin(9999, Abs(Value));

	if ( Mag >= 1000 )
	{
		Canvas.CurX -= Step;
		d = 0.001 * Mag;
		DrawDigit(Canvas, d, Step, UpScale, bMinus);
		Mag = Mag - 1000 * d;
		d = 0.01 * Mag;
		DrawDigit(Canvas, d, Step, UpScale, bMinus);
		Mag = Mag - 100 * d;
	}
	else if ( Mag >= 100 )
	{
		d = 0.01 * Mag;
		DrawDigit(Canvas, d, Step, UpScale, bMinus);
		Mag = Mag - 100 * d;
	}
	else
		Canvas.CurX += Step;

	if ( Mag >= 10 )
	{
		d = 0.1 * Mag;
		DrawDigit(Canvas, d, Step, UpScale, bMinus);
		Mag = Mag - 10 * d;
	}
	else if ( d > 0 )
		DrawDigit(Canvas, 0, Step, UpScale, bMinus);
	else
		Canvas.CurX += Step;

	DrawDigit(Canvas, Mag, Step, UpScale, bMinus);
}

simulated function DrawLowShield( canvas Canvas, Pawn P )
{

	Acolor -= 8;
	if ( Acolor < 0 )
		{
		Acolor = 255;
		P.PlaySound(Sound'UnrealShare.Eightball.SeekLost',,2.0);
		}

	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor.R = Acolor;
	Canvas.DrawColor.G = 0;
	Canvas.DrawColor.B = 0;
	Canvas.SetPos( Canvas.ClipX * 0.5 - 128, Canvas.ClipY - 210);
	Canvas.DrawIcon(Texture'LowShield', 0.5);
}

simulated function DrawLowFuel( canvas Canvas, Pawn P )
{

	Acolor -= 8;
	if ( Acolor < 0 )
		{
		Acolor = 255;
		P.PlaySound(Sound'UnrealShare.Eightball.SeekLost',,2.0);
		}

	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor.R = Acolor;
	Canvas.DrawColor.G = 0;
	Canvas.DrawColor.B = 0;
	Canvas.SetPos( Canvas.ClipX * 0.5 - 128, Canvas.ClipY - 242);
	Canvas.DrawIcon(Texture'LowFuel', 0.5);
}

function DrawScreenInfo(Canvas Canvas)
{
local float XL,YL;
local float Spct;
local float Fpct;

	//Draw Speed:
	Canvas.Font = Font'WhiteFont';
	Canvas.DrawColor.R = 255;
	Canvas.DrawColor.G = 255;
	Canvas.DrawColor.B = 255;
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.StrLen("Speed:"@int(Speed), XL, YL);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 0.5 * XL, Canvas.ClipY - 150 );
	Canvas.DrawText("Speed:"@int(Speed), true);

	//Draw Number of bullets:
	Canvas.StrLen("Shots:"@NumBullets, XL, YL);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 0.5 * XL, Canvas.ClipY - 150 + YL);
	Canvas.DrawText("Shots:"@NumBullets, true);

	//Draw Number of rockets:
	Canvas.StrLen("Rockets:"@NumRockets, XL, YL);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 0.5 * XL, Canvas.ClipY - 150 + 2*YL);
	Canvas.DrawText("Rockets:"@NumRockets, true);

	//Draw shield:
	Spct = (float(Shield) / 500) * 100;
	Canvas.StrLen("Shield:"@int(Spct)$"%", XL, YL);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 0.5 * XL, Canvas.ClipY - 150 + 3*YL);
	Canvas.DrawText("Shield:"@int(Spct)$"%", true);

	//Draw Fuel:
	Fpct = (float(Fuel) / 5000) * 100;
	Canvas.StrLen("Fuel:"@int(Fpct)$"%", XL, YL);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 0.5 * XL, Canvas.ClipY - 150 + 4*YL);
	Canvas.DrawText("Fuel:"@int(Fpct)$"%", true);

	if ( Fuel < 500 )
		DrawLowFuel(Canvas,Pawn(Owner));
	if ( Spct < 15 )
		DrawLowShield(Canvas,Pawn(Owner));
}

function DrawCompas(canvas C)
{
local float Xpos, XL, YL, X, Y, N, S, E, W, Dot, Ypos;
local Pawn P;
local int Degrees;

	P = Pawn(Owner);
	//P.ViewRotation.Pitch = up/down
	C.Font = Font'WhiteFont';
	c.DrawColor.R = 255;
	c.DrawColor.G = 255;
	c.DrawColor.B = 255;
	C.Style = ERenderStyle.STY_Normal;

	N = P.ViewRotation.Yaw / 10430.37835;
	W = (P.ViewRotation.Yaw - 16384) / 10430.37835;
	S = (P.ViewRotation.Yaw - 32768) / 10430.37835;
	E = (P.ViewRotation.Yaw + 16384) / 10430.37835;
	
	XPos = C.ClipX * 0.5 - 227;
	YPos = C.ClipY - 69;
	YL = 48;
	
	//Draw N
	X = Cos(N);
	Y = Sin(N);
	C.SetPos(Xpos + YL * X  , Ypos + YL * Y );
	C.DrawText("N", True);

	//Draw E
	X = Cos(E);
	Y = Sin(E);
	C.SetPos(Xpos + YL * X  , Ypos + YL * Y );
	C.DrawText("E", True);

	//Draw S
	X = Cos(S);
	Y = Sin(S);
	C.SetPos(Xpos + YL * X  , Ypos + YL * Y );
	C.DrawText("S", True);

	//Draw W
	X = Cos(W);
	Y = Sin(W);
	C.SetPos(Xpos + YL * X  , Ypos + YL * Y );
	C.DrawText("W", True);

	//Draw Dots
	C.Style = ERenderStyle.STY_Translucent;
	Dot = (P.ViewRotation.Yaw + 8192) / 10430.37835;
	X = Cos(Dot);
	Y = Sin(Dot);
	C.SetPos(Xpos + YL * X  , Ypos + YL * Y );
	c.DrawIcon(Texture'Dot', 1);
	Dot = (P.ViewRotation.Yaw + 24576) / 10430.37835;
	X = Cos(Dot);
	Y = Sin(Dot);
	C.SetPos(Xpos + YL * X  , Ypos + YL * Y );
	c.DrawIcon(Texture'Dot', 1);
	Dot = (P.ViewRotation.Yaw + 40960) / 10430.37835;
	X = Cos(Dot);
	Y = Sin(Dot);
	C.SetPos(Xpos + YL * X  , Ypos + YL * Y );
	c.DrawIcon(Texture'Dot', 1);
	Dot = (P.ViewRotation.Yaw + 57344) / 10430.37835;
	X = Cos(Dot);
	Y = Sin(Dot);
	C.SetPos(Xpos + YL * X  , Ypos + YL * Y );
	c.DrawIcon(Texture'Dot', 1);

	//Draw Pitch
	C.Style = ERenderStyle.STY_Normal;
	if ( P.ViewRotation.Pitch <=18000 && P.ViewRotation.Pitch >=0 )
		{
		Degrees = P.ViewRotation.Pitch / 200;
		C.StrLen("+"$Degrees$"", XL, YL);
		C.SetPos(Xpos + 4 - 0.5 * XL, Ypos + 2.5 * YL);
		C.DrawText("+"$Degrees$"", True);
		}
	else
		{
		Degrees = (65536 - P.ViewRotation.Pitch) / 200;
		C.StrLen("-"$Degrees$"", XL, YL);
		C.SetPos(Xpos + 4 - 0.5 * XL, Ypos + 2.5 * YL);
		C.DrawText("-"$Degrees$"", True);
		}
}

simulated function DrawRadar(Canvas C)
{
local float Dist, XL, YL, Scale, TempScale;
local Pawn P;
local int XPos, YPos;
local Vector X,Y,Z, Dir;


	GetAxes(Owner.Rotation, X, Y, Z);
	C.Style = ERenderStyle.STY_Translucent;

	foreach VisibleCollidingActors(class'Pawn', P, 5000, Owner.Location, true)
		{
		//Set name to display on HUD

		if ( P.PlayerReplicationInfo.Team == 0 )
			{
			c.DrawColor.R = 255;
			c.DrawColor.G = 0;
			c.DrawColor.B = 0;
			}
		else if ( P.PlayerReplicationInfo.Team == 1 )
			{
			c.DrawColor.R = 0;
			c.DrawColor.G = 0;
			c.DrawColor.B = 255;
			}
		else if ( P.PlayerReplicationInfo.Team == 2 )
			{
			c.DrawColor.R = 0;
			c.DrawColor.G = 255;
			c.DrawColor.B = 0;
			}
		else
			{
			c.DrawColor.R = 0;
			c.DrawColor.G = 255;
			c.DrawColor.B = 255;
			}

		Dir = P.Location - Owner.Location;

		Dist = VSize(Dir);

		TempScale = Dist / 20;

		Scale = 272 - TempScale;

		if ( Scale > 256 )
			Scale = 256;
		else if ( Scale < 16 )
			Scale = 16;

		Dir = Dir / Dist;
		C.StrLen(P.PlayerReplicationInfo.PlayerName$"("$P.Health$")", XL, YL);
		if ((Dir Dot X) > 0.7)
			{
			XPos = 0.5 * C.ClipX * (1 + 1.4 * (Dir Dot Y));
			if (XPos < 0)
				{
				XPos = 0;
				}
			if (Xpos > C.ClipX - XL)
				{
				Xpos = C.ClipX - XL;
				}
			YPos = 0.5 * C.ClipY * (1 - 1.4 * (Dir Dot Z));
			if ( Dist < 5000 )
				{
				C.SetPos(Xpos , YPos );
				C.DrawText(P.PlayerReplicationInfo.PlayerName$"("$P.Health$")", true);
				}
			Xpos -= 0.5 * Scale;
			Ypos -= 0.5 * Scale;
			if (XPos < 0)
				{
				XPos = 0;
				}
			if (Xpos > C.ClipX - 64)
				{
				Xpos = C.ClipX - 64;
				}
			C.SetPos(Xpos, YPos);
			C.DrawTile(Texture'Circle', Scale, Scale, 0, 0, 256, 256);
			}
		}
}

simulated function DrawRadarDots(Canvas C) 
{
	
local Pawn P;
local float Dist,RadarScale , RadarWidth, PulseBrightness,DotSize , Angle, OffsetY, OffsetScale,XOffsetScale, ResY, ResX;
local rotator Dir;
local vector Start;
local Pawn Driver;

/*	//just for test
	C.SetPos(0, 0.5 * C.ClipY);
	C.DrawText("Resolution:"@int(C.ClipX)$" x"@int(C.ClipY));
*/
	Driver = Pawn(Owner);
	DotSize = 5;

	RadarScale = 1;
	RadarWidth = 0.5 * RadarScale * C.ClipX;
	if (Driver == None)
		return;
	else
		Start = Driver.Location;
	
	C.Style = ERenderStyle.STY_Masked;
	//C.SetPos(C.ClipX * 0.5 + 160, c.ClipY - 130); only used as referense to Y pos set below
	ResX = C.ClipX * 0.5 + 128;
	ResY = C.ClipY - 120;

	foreach AllActors(class'Pawn', P)
		{

		//if (P.Health > 0 && P != Driver)
		if (P.Health > 0)
                        {

			Dist = VSize(Start - P.Location);
			if (Dist < 3000)
				{

				if ( P.PlayerReplicationInfo.Team == 0 )
					{
					C.DrawColor.R = 255;
					C.DrawColor.G = 0;
					C.DrawColor.B = 0;
					}
				else if ( P.PlayerReplicationInfo.Team == 1 )
					{
					C.DrawColor.R = 0;
					C.DrawColor.G = 0;
					C.DrawColor.B = 255;
					}
				else if ( P.PlayerReplicationInfo.Team == 2 )
					{
					C.DrawColor.R = 0;
					C.DrawColor.B = 0;
					C.DrawColor.G = 255;
					}
				else
					{
					C.DrawColor.R = 0;
					C.DrawColor.G = 255;
					C.DrawColor.B = 255;
					}
 
				Dir = rotator(P.Location - Start);
				OffsetScale = 0.11 * Dist * 0.000167; // 0.2 = RadarScale
				XOffsetScale = 0.055 * Dist * 0.000167; // 0.2 = RadarScale
				Angle = ((Dir.Yaw - Driver.Rotation.Yaw) & 65535) * 6.2832 / 65536;
				//C.SetPos(ResX + 0.05 * C.ClipX + XOffsetScale * C.ClipX * sin(Angle) - 0.5 * DotSize,ResY + 0.05 * C.ClipY - OffsetScale * C.ClipY * cos(Angle) - 0.5 * DotSize);
				C.SetPos(ResX + 0.05 * C.ClipX + XOffsetScale * C.ClipX * sin(Angle) - 0.5 * DotSize,ResY + 0.05 * C.ClipY - OffsetScale * C.ClipY * cos(Angle) - 0.5 * DotSize);
				C.DrawTile(Texture'Beacon', DotSize, DotSize, 0, 0, 16, 16);

				}
			}
		}      
}

simulated function Timer()
{
	local ut_SpriteSmokePuff b;
	local float SmokeRate;

	if ( (Role == ROLE_Authority) && (Level.TimeSeconds - ServerUpdate > 4) )
	{
		Explode(Location,Vect(0,0,1));
		return;
	}

	if ( Trail == None && !Region.Zone.bWaterZone && (Level.NetMode != NM_DedicatedServer) )
		Trail = Spawn(class'RedeemerTrail',self);

	CannonTimer += SmokeRate;
	if ( CannonTimer > 0.6 )
	{
		WarnCannons();
		CannonTimer -= 0.6;
	}

	b = Spawn(class'ut_SpriteSmokePuff');
	b.RemoteRole = ROLE_None;
	SetTimer(0.02, false);

	Fuel--;
	if ( Fuel < 0 )
		Fuel = 0;

}


simulated function Destroyed()
{
	local Jet W;

	bDestroyed = true;
	if ( (PlayerPawn(Guider) != None) )
		PlayerPawn(Guider).ViewTarget = None;

	While ( FreeMoves != None )
	{
		FreeMoves.Destroy();
		FreeMoves = FreeMoves.NextMove;
	}

	While ( SavedMoves != None )
	{
		SavedMoves.Destroy();
		SavedMoves = SavedMoves.NextMove;
	}

	if ( (Guider != None) && (Level.NetMode != NM_Client) )
	{
		W = Jet(Guider.FindInventoryType(class'Jet'));
		if ( W != None )
		{
			W.GuidedShell = None;
			W.GotoState('Finishing');
		}
	}
	Super.Destroyed();
}

simulated function Tick(float DeltaTime)
{
local int DeltaYaw, DeltaPitch;
local int YawDiff, PitchDiff;
local SavedMove NewMove;

	if ( Level.NetMode == NM_Client )
	{
		if ( (PlayerPawn(Instigator) != None) && (ViewPort(PlayerPawn(Instigator).Player) != None) )
		{
			Guider = Instigator;
			if ( bDestroyed || (Instigator.health < 0) )
			{
				PlayerPawn(Instigator).ViewTarget = None;
				Destroy();
				if ( Instigator.Weapon.IsA('Jet') )
					Jet(Instigator.Weapon).bGuiding = false;
				return;
			}
			PlayerPawn(Instigator).ViewTarget = self;
			if ( Instigator.Weapon.IsA('Jet') )
			{
				Jet(Instigator.Weapon).GuidedShell = self;
				Jet(Instigator.Weapon).bGuiding = true;
			}
		}
		else
		{
			if ( RealLocation != vect(0,0,0) )
			{
				SetLocation(RealLocation);
				RealLocation = vect(0,0,0);
			}
			if ( RealVelocity != vect(0,0,0) )
			{
				Velocity = RealVelocity;
				SetRotation(rotator(Velocity));
				RealVelocity = vect(0,0,0);
			}
			return;
		}
	}
	else if ( (Level.NetMode != NM_Standalone) && (RemoteRole == ROLE_AutonomousProxy) ) 
			return;

	// if server updated client position, client needs to replay moves after the update
	if ( bUpdatePosition )
		ClientUpdatePosition();

	DeltaYaw = (Guider.ViewRotation.Yaw & 65535) - (OldGuiderRotation.Yaw & 65535);
	DeltaPitch = (Guider.ViewRotation.Pitch & 65535) - (OldGuiderRotation.Pitch & 65535);
	if ( DeltaPitch < -32768 )
		DeltaPitch += 65536;
	else if ( DeltaPitch > 32768 )
		DeltaPitch -= 65536;
	if ( DeltaYaw < -32768 )
		DeltaYaw += 65536;
	else if ( DeltaYaw > 32768 )
		DeltaYaw -= 65536;

	YawDiff = (Rotation.Yaw & 65535) - (GuidedRotation.Yaw & 65535) - DeltaYaw;
	if ( DeltaYaw < 0 )
	{
		if ( ((YawDiff > 0) && (YawDiff < 16384)) || (YawDiff < -49152) )
			GuidedRotation.Yaw += DeltaYaw;
	}	
	else if ( ((YawDiff < 0) && (YawDiff > -16384)) || (YawDiff > 49152) )
		GuidedRotation.Yaw += DeltaYaw;

	GuidedRotation.Pitch += DeltaPitch;
	OldGuiderRotation = Guider.ViewRotation;
	if ( Role == ROLE_AutonomousProxy )
	{
		// Send the move to the server
		// skip move if too soon
		if ( ClientBuffer < 0 )
		{
			ClientBuffer += DeltaTime;
			MoveRocket(DeltaTime, Velocity, GuidedRotation);
			return;
		}
		else
			ClientBuffer = ClientBuffer + DeltaTime - 80.0/PlayerPawn(Instigator).Player.CurrentNetSpeed;

		// I'm  a client, so I'll save my moves in case I need to replay them
		// Get a SavedMove actor to store the movement in.
		if ( SavedMoves == None )
		{
			SavedMoves = GetFreeMove();
			NewMove = SavedMoves;
		}
		else
		{
			NewMove = SavedMoves;
			while ( NewMove.NextMove != None )
				NewMove = NewMove.NextMove;
			NewMove.NextMove = GetFreeMove();
			NewMove = NewMove.NextMove;
		}

		NewMove.TimeStamp = Level.TimeSeconds;
		NewMove.Delta = DeltaTime;
		NewMove.Velocity = Velocity;
		NewMove.SetRotation(GuidedRotation);

		MoveRocket(DeltaTime, Velocity, GuidedRotation);
		ServerMove(Level.TimeSeconds, Location, NewMove.Rotation.Pitch, NewMove.Rotation.Yaw);
		return;
	}
	MoveRocket(DeltaTime, Velocity, GuidedRotation);
}

// Server sends ClientAdjustPosition to the client to adjust the warhead position on the client side when the error
// is excessive
simulated function ClientAdjustPosition
(
	float TimeStamp, 
	float NewLocX, 
	float NewLocY, 
	float NewLocZ, 
	float NewVelX, 
	float NewVelY, 
	float NewVelZ
)
{
	local vector NewLocation;

	if ( CurrentTimeStamp > TimeStamp )
		return;
	CurrentTimeStamp = TimeStamp;

	NewLocation.X = NewLocX;
	NewLocation.Y = NewLocY;
	NewLocation.Z = NewLocZ;
	Velocity.X = NewVelX;
	Velocity.Y = NewVelY;
	Velocity.Z = NewVelZ;

	SetLocation(NewLocation);

	bUpdatePosition = true;
}

// Client calls this to replay moves after getting its position updated by the server
simulated function ClientUpdatePosition()
{
	local SavedMove CurrentMove;
	local int realbRun, realbDuck;
	local bool bRealJump;

	bUpdatePosition = false;
	CurrentMove = SavedMoves;
	while ( CurrentMove != None )
	{
		if ( CurrentMove.TimeStamp <= CurrentTimeStamp )
		{
			SavedMoves = CurrentMove.NextMove;
			CurrentMove.NextMove = FreeMoves;
			FreeMoves = CurrentMove;
			FreeMoves.Clear();
			CurrentMove = SavedMoves;
		}
		else
		{
			MoveRocket(CurrentMove.Delta, CurrentMove.Velocity, CurrentMove.Rotation);
			CurrentMove = CurrentMove.NextMove;
		}
	}
}
	
// server moves the rocket based on clients input, and compares the resultant location to the client's view of the location
function ServerMove(float TimeStamp, vector ClientLoc, int Pitch, int Yaw)
{
	local float ClientErr, DeltaTime;
	local vector LocDiff;

	if ( CurrentTimeStamp >= TimeStamp )
		return;

	if ( CurrentTimeStamp > 0 )
		DeltaTime = TimeStamp - CurrentTimeStamp;
	CurrentTimeStamp = TimeStamp;
	GuidedRotation.Pitch = Pitch;
	GuidedRotation.Yaw = Yaw;
	if ( DeltaTime > 0 )	
		MoveRocket(DeltaTime, Velocity, GuidedRotation);
	if ( Level.TimeSeconds - LastUpdateTime > 0.3 )
	{
		ClientErr = 10000;
	}
	else if ( Level.TimeSeconds - LastUpdateTime > 0.07 )
	{
		LocDiff = Location - ClientLoc;
		ClientErr = LocDiff Dot LocDiff;
	}

	// If client has accumulated a noticeable positional error, correct him.
	if ( ClientErr > 3 )
	{
		LastUpdateTime = Level.TimeSeconds;
		ClientAdjustPosition(TimeStamp, Location.X, Location.Y, Location.Z, Velocity.X, Velocity.Y, Velocity.Z);
	}
}

simulated function MoveRocket(float DeltaTime, vector CurrentVelocity, rotator GuideRotation )
{
	local int OldRoll, RollMag;
	local rotator NewRot;
	local float SmoothRoll;
	local vector OldVelocity, X,Y,Z;

	if ( (Role == ROLE_Authority) && ( (Guider == None) || (Guider.Health <= 0)
				|| (Guider.IsA('PlayerPawn') && (PlayerPawn(Guider).ViewTarget != self)) || Guider.IsInState('FeigningDeath')) )
	{
		Explode(Location,Vect(0,0,1));
		return;
	}

	if ( Fuel < 1 )
		{
		Self.SetPhysics(PHYS_Falling);
		Instigator.SetLocation(Location);
		Instigator.SetPhysics(PHYS_Falling);
		RealLocation = Location;
		RealVelocity = Velocity;
		return;
		}

	ServerUpdate = Level.TimeSeconds;
	OldRoll = Rotation.Roll & 65535;
	OldVelocity = CurrentVelocity;
	Velocity = CurrentVelocity + Vector(GuideRotation) * 1500 * DeltaTime;
	Velocity = Normal(Velocity) * 550;
	NewRot = Rotator(Velocity);

	// Roll Warhead based on acceleration
	GetAxes(NewRot, X,Y,Z);
	RollMag = int(10 * (Y Dot (Velocity - OldVelocity))/DeltaTime);
	if ( RollMag > 0 ) 
		NewRot.Roll = Min(12000, RollMag); 
	else
		NewRot.Roll = Max(53535, 65536 + RollMag);

	//smoothly change rotation
	if (NewRot.Roll > 32768)
	{
		if (OldRoll < 32768)
			OldRoll += 65536;
	}
	else if (OldRoll > 32768)
		OldRoll -= 65536;

	SmoothRoll = FMin(1.0, 5.0 * deltaTime);
	NewRot.Roll = NewRot.Roll * SmoothRoll + OldRoll * (1 - SmoothRoll);
	SetRotation(NewRot);

	if ( (Level.NetMode != NM_Standalone)
		&& ((Level.NetMode != NM_ListenServer) || (Instigator == None) 
			|| (Instigator.IsA('PlayerPawn') && (PlayerPawn(Instigator).Player != None)
				&& (ViewPort(PlayerPawn(Instigator).Player) == None))) )
		AutonomousPhysics(DeltaTime);

	if ( Role == ROLE_Authority )
		{
		RealLocation = Location;
		RealVelocity = Velocity;
		Instigator.SetLocation(Location);
		Instigator.bHidden = True;
		Instigator.SetPhysics(PHYS_Flying);
		Instigator.SetRotation(NewRot);
		}
}

simulated function PostRender( canvas Canvas )
{
	DrawCockpit(Canvas);
}		

simulated function SavedMove GetFreeMove()
{
	local SavedMove s;

	if ( FreeMoves == None )
		return Spawn(class'SavedMove');
	else
	{
		s = FreeMoves;
		FreeMoves = FreeMoves.NextMove;
		s.NextMove = None;
		return s;
	}	
}

//Hacked function to fire while flying
function PrimaryFire()
{
local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z, AimDir;
local actor Other;
local Rotator AdjustedAim;
local float AimError, Accuracy;
local int NumPoints;
local JetBeamRed JBR;
local JetBeamBlue JBB;

		if ( Role < ROLE_Authority || NumBullets <= 0)
			return;

		NumBullets--;

		AimError = 0.0; //test?
		Accuracy = 1; //test?
		GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
		StartTrace = Owner.Location + Vect(0,0,-40);
		AimDir = Vector(Owner.Rotation);
		EndTrace = (Owner.Location + Vect(0,0,-40)) + 10000 * AimDir;
		Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);
		Owner.PlaySound(Sound 'UnrealShare.ASMD.TazerFire',, 4.0,,100);

		if (Pawn(Owner).PlayerReplicationInfo.Team == 0 )
			{
			JBR = Spawn(class'JetBeamRed',,, StartTrace + 96 * AimDir + Vect(0,0,-40),rotator((EndTrace + Vect(0,0,40)) - StartTrace));
			JBR.MoveAmount = (EndTrace-StartTrace) / 135;
			NumPoints = Vsize(EndTrace-StartTrace) / 135;
			JBR.NumPuffs = NumPoints - 1;
			}
		else
			{
			JBB = Spawn(class'JetBeamBlue',,, StartTrace + 96 * AimDir + Vect(0,0,-40),rotator((EndTrace + Vect(0,0,40)) - StartTrace));
			JBB.MoveAmount = (EndTrace-StartTrace) / 135;
			NumPoints = Vsize(EndTrace-StartTrace) / 135;
			JBB.NumPuffs = NumPoints - 1;
			}

		ProcessTraceHit(Other, HitLocation + Vect(0,0,30), HitNormal, X,Y,Z);	


}

//embedded to support function PrimaryFire:
function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{


	if (Other == Level)
		Spawn(class'UT_LightWallHitEffect',,, HitLocation, Rotator(HitLocation));
		//Spawn(class'UT_LightWallHitEffect',,, HitLocation+HitNormal, Rotator(HitNormal));
	else if ( (Other!=self) && (Other!=Owner) && (Other != None) ) 
	{
		if ( !Other.bIsPawn && !Other.IsA('Carcass') )
			spawn(class'UT_SpriteSmokePuff',,,HitLocation+HitNormal*9); 
		else
			Other.PlaySound(Sound 'ChunkHit',, 4.0,,100);

		if ( Other.IsA('Bot') && (FRand() < 0.2) )
			Pawn(Other).WarnTarget(Pawn(Owner), 500, X);

		Other.TakeDamage(150, Pawn(Owner), HitLocation, 30000*X, MyDamageType);
	}
}

function AltFire()
{
local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z, AimDir;
local Rotator AdjustedAim;
local float AimError, Accuracy;
local AltRocket AR;

		if ( Role < ROLE_Authority || NumRockets <= 0)
			return;

		NumRockets--;

		AimError = 0.5; //test?
		Accuracy = 1; //test?
		GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
		AimDir = Vector(Owner.Rotation);	
		StartTrace = Owner.Location + Vect(0,0,-40);
		EndTrace = StartTrace + 10000 * AimDir;
		
		if ( VSize(HitLocation - StartTrace) > 250 )
			{
			AR = Spawn(class'AltRocket',,, StartTrace + 96 * AimDir,rotator(EndTrace - StartTrace));
			AR.SetOwner(Pawn(Owner));
			AR.Speed = Speed * 1.5;
			}
}

auto state Flying
{
	function BeginState()
	{
		ServerUpdate = Level.TimeSeconds;
		GuidedRotation = Rotation;
		OldGuiderRotation = Rotation;
		Velocity = speed*vector(Rotation);
		Acceleration = vect(0,0,0);
		if ( (Level.NetMode != NM_Standalone) && (Role == ROLE_Authority) )
		{
			if ( (PlayerPawn(Instigator) != None) 
				&& (ViewPort(PlayerPawn(Instigator).Player) != None) )
				RemoteRole = ROLE_SimulatedProxy;
			else
				RemoteRole = ROLE_AutonomousProxy;
		}
	}

	
}

defaultproperties
{
     Speed=300
     Shield=500
     Fuel=1000
     NumBullets=200
     NumRockets=10
     MyDamageType='JetShot'
     RemoteRole=ROLE_DumbProxy
     NetPriority=3.000000
     CollisionRadius=32.000000
     CollisionHeight=20.000000
     Bcolor=255
}
